/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.Attribute;
import cn.com.jit.ida.util.pki.asn1.x509.ClearanceAttribute;
import cn.com.jit.ida.util.pki.asn1.x509.GroupAttribute;
import cn.com.jit.ida.util.pki.asn1.x509.RoleAttribute;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Attributes
implements DEREncodable {
    private DEREncodableVector atts = new DEREncodableVector();

    public static Attributes getInstance(Object o) {
        if (o == null || o instanceof Attributes) {
            return (Attributes)o;
        }
        if (o instanceof ASN1Sequence) {
            return new Attributes((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObject getDERObject() {
        DERSequence seq = new DERSequence(this.atts);
        return seq;
    }

    public Attributes(ASN1Sequence seq) {
        int i = 0;
        while (i < seq.size()) {
            this.atts.add(seq.getObjectAt(i));
            ++i;
        }
    }

    public Attributes(DEREncodableVector ats) {
        this.atts = ats;
    }

    public Attributes() {
        this.atts = new DEREncodableVector();
    }

    public void addAttribute(Attribute att) {
        this.atts.add(att.getDERObject());
    }

    public DEREncodableVector getAttributes() {
        return this.atts;
    }

    public void setAttributes(DEREncodableVector atts) {
        this.atts = atts;
    }

    public int getSize() {
        return this.atts.size();
    }

    public Attribute getAttributeAt(int i) {
        Attribute att = new Attribute((DERSequence)this.atts.get(i));
        String oid = att.getAttrType().getId();
        Attribute reAtt = null;
        if ("2.5.4.72".equals(oid)) {
            reAtt = new RoleAttribute();
        }
        if ("2.5.1.5.55".equals(oid)) {
            reAtt = new ClearanceAttribute();
        }
        if ("2.5.24.4".equals(oid)) {
            reAtt = new GroupAttribute();
        }
        reAtt.setAttrValues(att.getAttrValuesSet());
        return reAtt;
    }

    public Attributes(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,Attributes.Attributes(),\u5c5e\u6027\u96c6\u5408\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Node cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("attribute")) {
                Attribute attr = new Attribute(cnode);
                this.atts.add(attr);
            }
            ++i;
        }
    }
}

