/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.AttCertIssuer;
import cn.com.jit.ida.util.pki.asn1.x509.AttCertValidityPeriod;
import cn.com.jit.ida.util.pki.asn1.x509.Attributes;
import cn.com.jit.ida.util.pki.asn1.x509.Holder;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttributeCertificateInfo
implements DEREncodable {
    DERInteger attCertVersion;
    Holder holder;
    AttCertIssuer issuer;
    AlgorithmIdentifier signature;
    DERInteger serialNumber;
    AttCertValidityPeriod attrCertValidityPeriod;
    Attributes attributes;
    DERBitString issuerUniqueID;
    X509Extensions extensions;

    public AttributeCertificateInfo(ASN1Sequence seq) {
        this.attCertVersion = DERInteger.getInstance(seq.getObjectAt(0));
        this.holder = Holder.getInstance(seq.getObjectAt(1));
        this.issuer = AttCertIssuer.getInstance(seq.getObjectAt(2));
        this.signature = AlgorithmIdentifier.getInstance(seq.getObjectAt(3));
        this.serialNumber = DERInteger.getInstance(seq.getObjectAt(4));
        this.attrCertValidityPeriod = AttCertValidityPeriod.getInstance(seq.getObjectAt(5));
        this.attributes = Attributes.getInstance(seq.getObjectAt(6));
        int i = 7;
        while (i < seq.size()) {
            DEREncodable obj = seq.getObjectAt(i);
            if (obj instanceof DERBitString) {
                this.issuerUniqueID = DERBitString.getInstance(seq.getObjectAt(i));
            } else if (obj instanceof ASN1Sequence || obj instanceof X509Extensions) {
                this.extensions = X509Extensions.getInstance(seq.getObjectAt(i));
            }
            ++i;
        }
    }

    public AttributeCertificateInfo(Element node) throws PKIException {
        NodeList nodelist = node.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AttributeCertificateInfo.AttributeCertificateInfo()");
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Text txt;
            Node cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("Version")) {
                try {
                    txt = (Text)cnode.getFirstChild();
                    String str = txt.getData();
                    int intstr = Integer.parseInt(str.trim());
                    this.attCertVersion = new DERInteger(intstr);
                }
                catch (NumberFormatException e) {
                    throw new PKIException("NumberFormatException,AttributeCertificateInfo.AttributeCertificateInfo()", e);
                }
            }
            if (sname.equals("Holder")) {
                this.holder = new Holder(cnode);
            }
            if (sname.equals("Issuer")) {
                this.issuer = new AttCertIssuer(cnode);
            }
            if (sname.equals("Signature")) {
                NodeList nlsign = cnode.getChildNodes();
                if (nodelist.getLength() == 0) {
                    throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AttributeCertificateInfo.AttributeCertificateInfo");
                }
                Node ndSig = null;
                DERObjectIdentifier oid = null;
                String nameoid = null;
                int j = 0;
                while (j < nlsign.getLength()) {
                    Text txt2;
                    ndSig = nlsign.item(j);
                    String sndsig = ndSig.getNodeName();
                    if (sndsig.equals("OID")) {
                        txt2 = (Text)ndSig.getFirstChild();
                        String soid = txt2.getData();
                        oid = new DERObjectIdentifier(soid.trim());
                    }
                    if (sndsig.equals("name")) {
                        txt2 = (Text)ndSig.getFirstChild();
                        String str = txt2.getData();
                        nameoid = str.trim();
                    }
                    ++j;
                }
                byte[] arry = nameoid.getBytes();
                DEROctetString octstr = new DEROctetString(arry);
                this.signature = new AlgorithmIdentifier(oid, octstr);
            }
            if (sname.equals("serialNumber")) {
                try {
                    txt = (Text)cnode.getFirstChild();
                    String sSN = txt.getData();
                    BigInteger bigint = new BigInteger(sSN.trim(), 16);
                    this.serialNumber = new DERInteger(bigint);
                }
                catch (NumberFormatException e) {
                    throw new PKIException("NumberFormatException,AttributeCertificateInfo.AttributeCertificateInfo()", e);
                }
            }
            if (sname.equals("AttrCertValidityPeriod")) {
                this.attrCertValidityPeriod = new AttCertValidityPeriod(cnode);
            }
            if (sname.equals("Attributes")) {
                this.attributes = new Attributes(cnode);
            }
            if (sname.equals("issuerUniqueID")) {
                txt = (Text)cnode.getFirstChild();
                String sbit = txt.getData();
                this.issuerUniqueID = new DERBitString(sbit.trim().getBytes());
            }
            if (sname.equals("Extensions")) {
                this.extensions = new X509Extensions(cnode);
            }
            ++i;
        }
    }

    public DERInteger getAttCertVersion() {
        return this.attCertVersion;
    }

    public Holder getHolder() {
        return this.holder;
    }

    public AttCertIssuer getIssuer() {
        return this.issuer;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public DERBitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.attCertVersion);
        v.add(this.holder);
        v.add(this.issuer);
        v.add(this.signature);
        v.add(this.serialNumber);
        v.add(this.attrCertValidityPeriod);
        v.add(this.attributes.getDERObject());
        if (this.issuerUniqueID != null) {
            v.add(this.issuerUniqueID);
        }
        if (this.extensions != null) {
            v.add(this.extensions);
        }
        return new DERSequence(v);
    }
}

