/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Encodable;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERSet;
import cn.com.jit.ida.util.pki.asn1.x509.ClearanceSyntax;
import cn.com.jit.ida.util.pki.asn1.x509.IetfAttrSyntax;
import cn.com.jit.ida.util.pki.asn1.x509.RoleSyntax;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Attribute
extends ASN1Encodable {
    private DERObjectIdentifier attrType;
    private DEREncodableVector attrValues;
    public static final String ROLE_ATTRIBUTE_OID = "2.5.4.72";
    public static final String GROUP_ATTRIBUTE_OID = "2.5.24.4";
    public static final String CLEARANCE_ATTRIBUTE_OID = "2.5.1.5.55";

    public Attribute() {
        this.attrValues = new DEREncodableVector();
    }

    public static Attribute getInstance(Object o) {
        if (o == null || o instanceof Attribute) {
            return (Attribute)o;
        }
        if (o instanceof ASN1Sequence) {
            return new Attribute((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public Attribute(ASN1Sequence seq) {
        this.attrType = (DERObjectIdentifier)seq.getObjectAt(0);
        this.attrValues = new DEREncodableVector((ASN1Set)seq.getObjectAt(1));
    }

    public Attribute(DERObjectIdentifier attrType, ASN1Set attrValues) {
        this.attrType = attrType;
        this.attrValues = new DEREncodableVector(attrValues);
    }

    public DERObjectIdentifier getAttrType() {
        return this.attrType;
    }

    public ASN1Set getAttrValuesSet() {
        return new DERSet(this.attrValues);
    }

    public DEREncodableVector getAttrValues() {
        return this.attrValues;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.attrType);
        v.add(this.getAttrValuesSet());
        return new DERSequence(v);
    }

    public int getAttributeValuesSize() {
        return this.attrValues.size();
    }

    public ASN1Encodable getValueObjAt(int i) {
        return (ASN1Encodable)this.attrValues.get(i);
    }

    protected void setTttrType(DERObjectIdentifier type) {
        this.attrType = type;
    }

    protected void setTttrType(String oid) {
        this.attrType = new DERObjectIdentifier(oid);
    }

    public void setAttrValues(ASN1Set values) {
        this.attrValues = new DEREncodableVector(values);
    }

    public void setAttrValues(DEREncodableVector attrValues) {
        this.attrValues = attrValues;
    }

    protected void addAttValueObject(DEREncodable obj) {
        if (this.attrValues == null) {
            this.attrValues = new DEREncodableVector();
        }
        this.attrValues.add(obj);
    }

    public Attribute(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,Attribute.Attribute(),Attribute\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Node cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("type")) {
                Text txt = (Text)cnode.getFirstChild();
                String stype = txt.getData();
                this.attrType = new DERObjectIdentifier(stype.trim());
            }
            if (sname.equals("attrvalues")) {
                this.attrValues = this.generateAttrvalues(cnode);
            }
            ++i;
        }
    }

    public DEREncodableVector generateAttrvalues(Node nl) throws PKIException {
        DEREncodableVector vector = new DEREncodableVector();
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,Attrvalues,\u5c5e\u6027\u503c\u96c6\u5408\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        RoleSyntax roleattr = null;
        IetfAttrSyntax groupattr = null;
        ClearanceSyntax clrattr = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("RoleAttribute")) {
                roleattr = new RoleSyntax(cnode);
                vector.add(roleattr);
            }
            if (sname.equals("ClearanceAttribute")) {
                clrattr = new ClearanceSyntax(cnode);
                vector.add(clrattr);
            }
            if (sname.equals("GroupAttribute")) {
                groupattr = new IetfAttrSyntax(cnode);
                vector.add(groupattr);
            }
            ++i;
        }
        return vector;
    }
}

