/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERGeneralizedTime;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttCertValidityPeriod
implements DEREncodable {
    DERGeneralizedTime notBeforeTime;
    DERGeneralizedTime notAfterTime;

    public static AttCertValidityPeriod getInstance(Object obj) {
        if (obj instanceof AttCertValidityPeriod) {
            return (AttCertValidityPeriod)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new AttCertValidityPeriod((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AttCertValidityPeriod(DERGeneralizedTime notBeforeTime, DERGeneralizedTime notAfterTime) {
        this.notBeforeTime = notBeforeTime;
        this.notAfterTime = notAfterTime;
    }

    public AttCertValidityPeriod(ASN1Sequence seq) {
        this.notBeforeTime = (DERGeneralizedTime)seq.getObjectAt(0);
        this.notAfterTime = (DERGeneralizedTime)seq.getObjectAt(1);
    }

    public DERGeneralizedTime getNotBeforeTime() {
        return this.notBeforeTime;
    }

    public DERGeneralizedTime getNotAfterTime() {
        return this.notAfterTime;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.notBeforeTime);
        v.add(this.notAfterTime);
        return new DERSequence(v);
    }

    public AttCertValidityPeriod(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AttrCertValidityPeriod.AttrCertValidityPeriod(),\u5c5e\u6027\u8bc1\u4e66\u6709\u6548\u671f\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            String value;
            Text txt;
            Node cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("notBefore")) {
                txt = (Text)cnode.getFirstChild();
                value = txt.getData();
                this.notBeforeTime = new DERGeneralizedTime(value.trim());
            }
            if (sname.equals("notAfter")) {
                txt = (Text)cnode.getFirstChild();
                value = txt.getData();
                this.notAfterTime = new DERGeneralizedTime(value.trim());
            }
            ++i;
        }
    }
}

