/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.V2Form;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttCertIssuer
implements DEREncodable {
    V2Form v2form;
    DERObject choiceObj;

    public static AttCertIssuer getInstance(String issuer) {
        DEREncodableVector ve = new DEREncodableVector();
        X509Name name = new X509Name(issuer);
        GeneralName gn = new GeneralName(name);
        ve.add(gn.getDERObject());
        DERSequence seq = new DERSequence(ve);
        GeneralNames ns = new GeneralNames(seq);
        V2Form form = new V2Form();
        form.setIssuerName(ns);
        return AttCertIssuer.getInstance(form);
    }

    public static AttCertIssuer getInstance(Object obj) {
        if (obj instanceof AttCertIssuer) {
            return (AttCertIssuer)obj;
        }
        if (obj instanceof V2Form) {
            return new AttCertIssuer(V2Form.getInstance(obj));
        }
        if (obj instanceof GeneralNames) {
            return new AttCertIssuer((GeneralNames)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            return new AttCertIssuer(V2Form.getInstance((ASN1TaggedObject)obj, true));
        }
        if (obj instanceof ASN1Sequence) {
            return new AttCertIssuer(GeneralNames.getInstance(obj));
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass());
    }

    public static AttCertIssuer getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AttCertIssuer.getInstance(obj.getObject());
    }

    public AttCertIssuer(GeneralNames names) {
        this.v2form = new V2Form(names);
        this.choiceObj = this.v2form.getDERObject();
    }

    public AttCertIssuer(V2Form v2Form) {
        this.v2form = v2Form;
        this.choiceObj = new DERTaggedObject(true, 0, this.v2form.getDERObject());
    }

    public DERObject getDERObject() {
        if (this.choiceObj == null && this.v2form != null) {
            this.choiceObj = new DERTaggedObject(true, 0, this.v2form.getDERObject());
        }
        return this.choiceObj;
    }

    public String[] toStringArr() {
        if (this.v2form == null) {
            return null;
        }
        GeneralNames issuerName = this.v2form.getIssuerName();
        String[] names = new String[issuerName.getNames().length];
        int i = 0;
        while (i < names.length) {
            names[i] = issuerName.getNames()[i].toString();
            ++i;
        }
        return names;
    }

    public String toString() {
        if (this.v2form == null) {
            return null;
        }
        String[] a = this.toStringArr();
        if (a != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < a.length) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(a[i]);
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public AttCertIssuer(Node nl) throws PKIException {
        this.v2form = null;
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,AttCertIssuer.AttCertIssuer(),Issuer\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("V2Form")) {
                this.v2form = new V2Form(cnode);
            }
            ++i;
        }
    }
}

