/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.Targets;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import cn.com.jit.ida.util.pki.extension.AbstractStandardExtension;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ACTargetingExtension
extends AbstractStandardExtension {
    private DERObjectIdentifier extnID = X509Extensions.ACTargeting;
    private DERBoolean critical = new DERBoolean(true);
    private DEROctetString extnValue;
    private DEREncodableVector targetsVec;

    public String getOID() {
        return this.extnID.getId();
    }

    public void setCritical(boolean critical) {
        this.critical = new DERBoolean(critical);
    }

    public boolean getCritical() {
        return this.critical.isTrue();
    }

    public ACTargetingExtension(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ACTargetingExtension.ACTargetingExtension(),\u5c5e\u6027\u8bc1\u4e66\u5b9a\u5411\u6269\u5c55\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        this.targetsVec = new DEREncodableVector();
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            String sname = cnode.getNodeName();
            if (sname.equals("Targets")) {
                Targets syntax = new Targets(cnode);
                this.targetsVec.add(syntax.getDERObject());
            }
            ++i;
        }
    }

    public DERObject toASN1Object() throws PKIException {
        DEREncodableVector vec = new DEREncodableVector();
        vec.add(this.extnID);
        vec.add(this.critical);
        DEREncodableVector vec1 = new DEREncodableVector();
        int i = 0;
        while (i < this.targetsVec.size()) {
            Targets tgs = (Targets)this.targetsVec.get(i);
            DERObject asnobj = tgs.getDERObject();
            vec1.add(asnobj);
            ++i;
        }
        DERSequence asn1 = new DERSequence(vec1);
        byte[] arr = Parser.writeDERObj2Bytes(asn1);
        this.extnValue = new DEROctetString(arr);
        vec.add(this.extnValue);
        return new DERSequence(vec);
    }

    public byte[] encode() throws PKIException {
        DERObject object = this.toASN1Object();
        return new DEROctetString(object).getOctets();
    }

    public void decode(DERObject parm1) throws PKIException {
        throw new UnsupportedOperationException("Method decode() not yet implemented.");
    }
}

