/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.x509;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.Parser;
import cn.com.jit.ida.util.pki.asn1.ASN1Encodable;
import cn.com.jit.ida.util.pki.asn1.DERBoolean;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.x509.DistributionPoint;
import cn.com.jit.ida.util.pki.asn1.x509.DistributionPointName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralName;
import cn.com.jit.ida.util.pki.asn1.x509.GeneralNames;
import cn.com.jit.ida.util.pki.asn1.x509.ReasonFlags;
import cn.com.jit.ida.util.pki.asn1.x509.X509Extensions;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ACRLDPExtension
extends ASN1Encodable {
    private DERObjectIdentifier extnID = X509Extensions.ACRLDPExtension;
    private DERBoolean critical = new DERBoolean(false);
    private DEROctetString extnValue;
    private DEREncodableVector syntax = new DEREncodableVector();

    public ACRLDPExtension(Node nl) throws PKIException {
        NodeList nodelist = nl.getChildNodes();
        if (nodelist.getLength() == 0) {
            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ACRLDPExtension.ACRLDPExtension,ACRLDPExtension\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        Node cnode = null;
        String sname = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            cnode = nodelist.item(i);
            sname = cnode.getNodeName();
            if (sname.equals("DistributionPoint")) {
                DistributionPoint dsp = new DistributionPoint();
                NodeList nldp = cnode.getChildNodes();
                if (nodelist.getLength() == 0) {
                    throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ACRLDPExtension.ACRLDPExtension, DistributionPoint\u6ca1\u6709\u5b50\u8282\u70b9");
                }
                Node dp = null;
                int j = 0;
                while (j < nldp.getLength()) {
                    dp = nldp.item(j);
                    String sdp = dp.getNodeName();
                    if (sdp.equals("DistributionPointName")) {
                        NamedNodeMap attributes = null;
                        GeneralName gname = null;
                        Node ndgname = null;
                        NodeList nlgn = dp.getChildNodes();
                        if (nodelist.getLength() == 0) {
                            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ACRLDPExtension.ACRLDPExtension,DistributionPointName\u6ca1\u6709\u5b50\u8282\u70b9");
                        }
                        int k = 0;
                        while (k < nlgn.getLength()) {
                            ndgname = nlgn.item(k);
                            String sgn = ndgname.getNodeName();
                            if (sgn.equals("GeneralName")) {
                                attributes = ndgname.getAttributes();
                                String type = attributes.item(0).getNodeValue();
                                gname = new GeneralName(ndgname);
                                DistributionPointName dname = new DistributionPointName(Integer.parseInt(type), gname.getDERObject());
                                dsp.setDistributionPoint(dname);
                                break;
                            }
                            ++k;
                        }
                    }
                    if (sdp.equals("reason")) {
                        try {
                            Text txt = (Text)dp.getFirstChild();
                            String str = txt.getData();
                            int intstr1 = Integer.parseInt(str.trim());
                            int intstr = 2 ^ intstr1;
                            ReasonFlags rf = new ReasonFlags(intstr);
                            dsp.setReasons(rf);
                        }
                        catch (NumberFormatException e) {
                            throw new PKIException("NumberFormatException, ACRLDPExtension.ACRLDPExtension, \u6784\u9020reason\u51fa\u9519", e);
                        }
                    }
                    if (sdp.equals("CRLIssuer")) {
                        NamedNodeMap attributes1 = null;
                        GeneralNames gnames1 = new GeneralNames();
                        Node ndgname1 = null;
                        NodeList nlgn1 = dp.getChildNodes();
                        if (nodelist.getLength() == 0) {
                            throw new PKIException("XML\u5185\u5bb9\u7f3a\u5931,ACRLDPExtension.ACRLDPExtension,CRLIssuer\u6ca1\u6709\u5b50\u8282\u70b9");
                        }
                        int l = 0;
                        while (l < nlgn1.getLength()) {
                            ndgname1 = nlgn1.item(l);
                            String sgn1 = ndgname1.getNodeName();
                            if (sgn1.equals("GeneralName")) {
                                attributes1 = ndgname1.getAttributes();
                                String type1 = attributes1.item(0).getNodeValue();
                                Text txt = (Text)ndgname1.getFirstChild();
                                String sdpname1 = txt.getData();
                                gnames1.addGeneralName(Integer.parseInt(type1), sdpname1.trim());
                            }
                            ++l;
                        }
                        dsp.setCRLIssuer(gnames1);
                    }
                    ++j;
                }
                this.syntax.add(dsp);
            }
            ++i;
        }
    }

    public DERObject toASN1Object() {
        DEREncodableVector seq = new DEREncodableVector();
        seq.add(this.extnID);
        seq.add(this.critical);
        DEREncodableVector seq1 = new DEREncodableVector();
        int i = 0;
        while (i < this.syntax.size()) {
            DistributionPoint dsp = (DistributionPoint)this.syntax.get(i);
            seq1.add(dsp.toASN1Object());
            ++i;
        }
        DERSequence asn1 = new DERSequence(seq1);
        byte[] arr = null;
        try {
            arr = Parser.writeDERObj2Bytes(asn1.getDERObject());
        }
        catch (PKIException e) {
            e.printStackTrace();
        }
        this.extnValue = new DEROctetString(arr);
        seq.add(this.extnValue);
        return new DERSequence(seq);
    }

    public void decode(DERObject parm1) throws PKIException {
        throw new UnsupportedOperationException("Method decode() not yet implemented.");
    }
}

