/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.pkcs.pkcs8;

import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.ASN1Set;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERInputStream;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DEROctetString;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.DERTaggedObject;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;

public class PrivateKeyInfo
implements PKCSObjectIdentifiers,
DEREncodable {
    private DERObject privKey;
    private AlgorithmIdentifier algId;
    private DERInteger version;
    private ASN1Set attributes;

    public PrivateKeyInfo(AlgorithmIdentifier algId, DERObject privateKey) {
        this.privKey = privateKey;
        this.algId = algId;
    }

    public PrivateKeyInfo(AlgorithmIdentifier algId, DERObject privateKey, ASN1Set attributes) {
        this.privKey = privateKey;
        this.algId = algId;
        this.attributes = attributes;
    }

    public PrivateKeyInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        BigInteger version = ((DERInteger)e.nextElement()).getValue();
        if (version.intValue() != 0) {
            throw new IllegalArgumentException("wrong version:" + version.intValue() + " for private key info");
        }
        this.algId = new AlgorithmIdentifier((ASN1Sequence)e.nextElement());
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(((ASN1OctetString)e.nextElement()).getOctets());
            DERInputStream dIn = new DERInputStream(bIn);
            this.privKey = dIn.readObject();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error recoverying private key from sequence");
        }
        if (e.hasMoreElements()) {
            this.attributes = ASN1Set.getInstance((ASN1TaggedObject)e.nextElement(), false);
        }
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPrivateKey() {
        return this.privKey;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(0));
        v.add(this.algId);
        v.add(new DEROctetString(this.privKey));
        if (this.attributes != null) {
            v.add(new DERTaggedObject(false, 0, this.attributes));
        }
        return new DERSequence(v);
    }
}

