/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1.pkcs;

import cn.com.jit.ida.util.pki.asn1.ASN1EncodableVector;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPrivateKeyStructure
implements DEREncodable {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;

    public RSAPrivateKeyStructure(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger prime1, BigInteger prime2, BigInteger exponent1, BigInteger exponent2, BigInteger coefficient) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.prime1 = prime1;
        this.prime2 = prime2;
        this.exponent1 = exponent1;
        this.exponent2 = exponent2;
        this.coefficient = coefficient;
    }

    public RSAPrivateKeyStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        BigInteger version = ((DERInteger)e.nextElement()).getValue();
        if (version.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for RSA private key");
        }
        this.modulus = ((DERInteger)e.nextElement()).getValue();
        this.publicExponent = ((DERInteger)e.nextElement()).getValue();
        this.privateExponent = ((DERInteger)e.nextElement()).getValue();
        this.prime1 = ((DERInteger)e.nextElement()).getValue();
        this.prime2 = ((DERInteger)e.nextElement()).getValue();
        this.exponent1 = ((DERInteger)e.nextElement()).getValue();
        this.exponent2 = ((DERInteger)e.nextElement()).getValue();
        this.coefficient = ((DERInteger)e.nextElement()).getValue();
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(0));
        v.add(new DERInteger(this.getModulus()));
        v.add(new DERInteger(this.getPublicExponent()));
        v.add(new DERInteger(this.getPrivateExponent()));
        v.add(new DERInteger(this.getPrime1()));
        v.add(new DERInteger(this.getPrime2()));
        v.add(new DERInteger(this.getExponent1()));
        v.add(new DERInteger(this.getExponent2()));
        v.add(new DERInteger(this.getCoefficient()));
        return new DERSequence(v);
    }
}

