/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1;

import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERTaggedObject
extends ASN1TaggedObject {
    public DERTaggedObject(int tagNo, DEREncodable obj) {
        super(tagNo, obj);
    }

    public DERTaggedObject(boolean explicit, int tagNo, DEREncodable obj) {
        super(explicit, tagNo, obj);
    }

    public DERTaggedObject(int tagNo) {
        super(false, tagNo, new DERSequence());
    }

    void encode(DEROutputStream out) throws IOException {
        if (!this.empty) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.obj);
            dOut.close();
            byte[] bytes = bOut.toByteArray();
            if (this.explicit) {
                out.writeEncoded(0xA0 | this.tagNo, bytes);
            } else {
                bytes[0] = (bytes[0] & 0x20) != 0 ? (byte)(0xA0 | this.tagNo) : (byte)(0x80 | this.tagNo);
                out.write(bytes);
            }
        } else {
            out.writeEncoded(0xA0 | this.tagNo, new byte[0]);
        }
    }
}

