/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki.asn1;

import cn.com.jit.ida.util.pki.asn1.ASN1OctetString;
import cn.com.jit.ida.util.pki.asn1.ASN1TaggedObject;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DERGeneralizedTime
extends DERObject {
    String time;

    public static DERGeneralizedTime getInstance(Object obj) {
        if (obj == null || obj instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERGeneralizedTime.getInstance(obj.getObject());
    }

    public DERGeneralizedTime(String time) {
        this.time = time;
    }

    public DERGeneralizedTime(Date time) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = dateF.format(time);
    }

    DERGeneralizedTime(byte[] bytes) {
        char[] dateC = new char[bytes.length];
        int i = 0;
        while (i != dateC.length) {
            dateC[i] = (char)(bytes[i] & 0xFF);
            ++i;
        }
        this.time = new String(dateC);
    }

    public String getTime() {
        if (this.time.charAt(this.time.length() - 1) == 'Z') {
            return String.valueOf(this.time.substring(0, this.time.length() - 1)) + "GMT+00:00";
        }
        int signPos = this.time.length() - 5;
        char sign = this.time.charAt(signPos);
        if (sign == '-' || sign == '+') {
            return String.valueOf(this.time.substring(0, signPos)) + "GMT" + this.time.substring(signPos, signPos + 3) + ":" + this.time.substring(signPos + 3);
        }
        signPos = this.time.length() - 3;
        sign = this.time.charAt(signPos);
        if (sign == '-' || sign == '+') {
            return String.valueOf(this.time.substring(0, signPos)) + "GMT" + this.time.substring(signPos) + ":00";
        }
        return this.time;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat localSimpleDateFormat;
        String str = this.time;
        if (this.time.endsWith("Z")) {
            localSimpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            localSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (this.time.indexOf(45) > 0 || this.time.indexOf(43) > 0) {
            str = this.getTime();
            localSimpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSSz") : new SimpleDateFormat("yyyyMMddHHmmssz");
            localSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            localSimpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            localSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        return localSimpleDateFormat.parse(str);
    }

    private boolean hasFractionalSeconds() {
        return this.time.indexOf(46) == 14;
    }

    private byte[] getOctets() {
        char[] cs = this.time.toCharArray();
        byte[] bs = new byte[cs.length];
        int i = 0;
        while (i != cs.length) {
            bs[i] = (byte)cs[i];
            ++i;
        }
        return bs;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(24, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.time.equals(((DERGeneralizedTime)o).time);
    }
}

