/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki;

import cn.com.jit.ida.util.pki.DSAParser;
import cn.com.jit.ida.util.pki.ECDSAParser;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.ASN1InputStream;
import cn.com.jit.ida.util.pki.asn1.ASN1Sequence;
import cn.com.jit.ida.util.pki.asn1.DERBitString;
import cn.com.jit.ida.util.pki.asn1.DEREncodable;
import cn.com.jit.ida.util.pki.asn1.DEREncodableVector;
import cn.com.jit.ida.util.pki.asn1.DERInteger;
import cn.com.jit.ida.util.pki.asn1.DERObject;
import cn.com.jit.ida.util.pki.asn1.DEROutputStream;
import cn.com.jit.ida.util.pki.asn1.DERSequence;
import cn.com.jit.ida.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.jit.ida.util.pki.asn1.pkcs.RSAPrivateKeyStructure;
import cn.com.jit.ida.util.pki.asn1.pkcs.pkcs8.PrivateKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.AlgorithmIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.CertificateList;
import cn.com.jit.ida.util.pki.asn1.x509.RSAPublicKeyStructure;
import cn.com.jit.ida.util.pki.asn1.x509.SubjectPublicKeyInfo;
import cn.com.jit.ida.util.pki.asn1.x509.X509CertificateStructure;
import cn.com.jit.ida.util.pki.cert.X509Cert;
import cn.com.jit.ida.util.pki.cipher.JKey;
import cn.com.jit.ida.util.pki.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.util.encoders.Base64;

public class Parser {
    private static final byte[] b64Code = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61, 13, 10};

    public static byte[] customData2SoftPublicKey(byte[] eccPublicKey, byte[] ecParams) throws PKIException {
        byte[] key = ECDSAParser.customData2SoftPublicKey(eccPublicKey, ecParams);
        return key;
    }

    public static byte[] customDSAData2SoftPublicKey(byte[] dsaPublicKey) throws PKIException {
        org.bouncycastle.asn1.x509.SubjectPublicKeyInfo info = new org.bouncycastle.asn1.x509.SubjectPublicKeyInfo(new org.bouncycastle.asn1.x509.AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, null), dsaPublicKey);
        return info.getDEREncoded();
    }

    public static SecretKey convertSecretKey(JKey jkey) throws PKIException {
        SecretKey secretKey = null;
        Object keySpec = null;
        try {
            if (jkey.getKeyType().equals("PBEWithMD5AndDES") || jkey.getKeyType().equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC") || jkey.getKeyType().equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC")) {
                char[] pwd = new String(jkey.getKey()).toCharArray();
                PBEKeySpec pbks = new PBEKeySpec(pwd);
                SecretKeyFactory kf = SecretKeyFactory.getInstance(jkey.getKeyType(), "BC");
                secretKey = kf.generateSecret(pbks);
                return secretKey;
            }
            secretKey = new SecretKeySpec(jkey.getKey(), jkey.getKeyType());
            return secretKey;
        }
        catch (Exception ex) {
            throw new PKIException("8131", "\u5bf9\u79f0\u5bc6\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    public static X509Certificate convertX509Cert2JavaCert(X509Cert cert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate javaCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            return javaCert;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static PrivateKey convertPrivateKey(JKey jkey) throws PKIException {
        String keyType = jkey.getKeyType();
        if (!(keyType.equals("RSA_Private") || keyType.equals("DSA_Private") || keyType.equals("ECIES_Private") || keyType.equals("SM2_Private") || keyType.equals("ECDSA_Private"))) {
            throw new PKIException("8132", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
        }
        PrivateKey prvKey = null;
        try {
            String alg = keyType.substring(0, keyType.indexOf("_"));
            if ("ECIES".equals(alg) || "ECDSA".equals(alg) || "SM2".equals(alg)) {
                ByteArrayInputStream bin = new ByteArrayInputStream(jkey.getKey());
                org.bouncycastle.asn1.ASN1InputStream ain = new org.bouncycastle.asn1.ASN1InputStream((InputStream)bin);
                org.bouncycastle.asn1.DERSequence seq = (org.bouncycastle.asn1.DERSequence)ain.readObject();
                org.bouncycastle.asn1.pkcs.PrivateKeyInfo in = new org.bouncycastle.asn1.pkcs.PrivateKeyInfo((org.bouncycastle.asn1.ASN1Sequence)seq);
                PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(jkey.getKey());
                KeyFactory f = KeyFactory.getInstance(alg, "BC");
                PrivateKey privKey = f.generatePrivate(privSpec);
                return privKey;
            }
            KeyFactory kf = KeyFactory.getInstance(alg, "BC");
            PKCS8EncodedKeySpec p8KeySpec = new PKCS8EncodedKeySpec(jkey.getKey());
            prvKey = kf.generatePrivate(p8KeySpec);
            return prvKey;
        }
        catch (Exception ex) {
            throw new PKIException("8132", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    public static PublicKey convertPublicKey(JKey jkey) throws PKIException {
        String keyType = jkey.getKeyType();
        if (!(keyType.equals("RSA_Public") || keyType.equals("DSA_Public") || keyType.equals("ECIES_Public") || keyType.equals("ECDSA_Public"))) {
            throw new PKIException("8133", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
        }
        PublicKey pubKey = null;
        try {
            String alg = keyType.substring(0, keyType.indexOf("_"));
            if ("ECIES".equals(alg) || "ECDSA".equals(alg)) {
                X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(jkey.getKey());
                KeyFactory f = KeyFactory.getInstance(alg, "BC");
                pubKey = f.generatePublic(pubSpec);
                return pubKey;
            }
            KeyFactory kf = KeyFactory.getInstance(alg, "BC");
            X509EncodedKeySpec x509spec = new X509EncodedKeySpec(jkey.getKey());
            pubKey = kf.generatePublic(x509spec);
            return pubKey;
        }
        catch (Exception ex) {
            throw new PKIException("8133", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    public static Key convertKey(JKey jkey) throws PKIException {
        String keyType = jkey.getKeyType();
        if (keyType.equals("DES") || keyType.equals("DESede") || keyType.equals("RC2") || keyType.equals("RC4") || keyType.equals("CAST5") || keyType.equals("IDEA") || keyType.equals("AES") || keyType.equals("PBEWithMD5AndDES") || keyType.equals("PBEWITHSHAAND2-KEYTRIPLEDES-CBC") || keyType.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC")) {
            return Parser.convertSecretKey(jkey);
        }
        if (keyType.equals("RSA_Private") || keyType.equals("DSA_Private") || keyType.equals("ECIES_Private") || keyType.equals("ECDSA_Private")) {
            return Parser.convertPrivateKey(jkey);
        }
        if (keyType.equals("RSA_Public") || keyType.equals("DSA_Public") || keyType.equals("ECIES_Public") || keyType.equals("ECDSA_Public")) {
            return Parser.convertPublicKey(jkey);
        }
        throw new PKIException("8130", "\u5bc6\u94a5\u8f6c\u6362\u64cd\u4f5c\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
    }

    public static SubjectPublicKeyInfo key2SPKI(JKey key) throws PKIException {
        String keyType = key.getKeyType();
        if (!(keyType.equals("RSA_Public") || keyType.equals("DSA_Public") || keyType.equals("ECIES_Public") || keyType.equals("SM2_Public") || keyType.equals("ECDSA_Public"))) {
            throw new PKIException("8134", "\u516c\u94a5\u8f6c\u6362\u4e3a\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
        }
        byte[] keyData = key.getKey();
        ByteArrayInputStream bis = new ByteArrayInputStream(keyData);
        ASN1InputStream ais = new ASN1InputStream(bis);
        ASN1Sequence sequence = null;
        try {
            sequence = (ASN1Sequence)ais.readObject();
            return new SubjectPublicKeyInfo(sequence);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PKIException("8134", "\u516c\u94a5\u8f6c\u6362\u4e3a\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u5931\u8d25", ex);
        }
    }

    public static JKey SPKI2Key(SubjectPublicKeyInfo spki) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(spki.getDERObject());
            byte[] key = bos.toByteArray();
            Object keyType = null;
            if (spki.getAlgorithmId().getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
                return new JKey("RSA_Public", key);
            }
            if (spki.getAlgorithmId().getObjectId().equals(PKCSObjectIdentifiers.ecEncryption)) {
                if (spki.getAlgorithmId().getParameters() != null) {
                    return new JKey("SM2_Public", key);
                }
                return new JKey("ECDSA_Public", key);
            }
            if (spki.getAlgorithmId().getObjectId().equals(PKCSObjectIdentifiers.ecEncryption)) {
                return new JKey("ECIES_Public", key);
            }
            if (spki.getAlgorithmId().getObjectId().equals(PKCSObjectIdentifiers.SM2_SIGN)) {
                return new JKey("SM2_Public", key);
            }
            return new JKey("JIT_COMM_KEY", key);
        }
        catch (Exception ex) {
            throw new PKIException("8135", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", ex);
        }
    }

    public static byte[] hardKey2SoftKey(String keyType, byte[] hardKey) throws PKIException {
        AlgorithmIdentifier keyAlg = null;
        byte[] key = null;
        if (keyType.equals("RSA_Public")) {
            try {
                keyAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
                SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, hardKey);
                key = Parser.writeDERObj2Bytes(spki);
            }
            catch (Exception ex) {
                throw new PKIException("8138", "\u52a0\u5bc6\u673a\u5bc6\u94a5\u8f6c\u6362\u8f6f\u5e93\u5bc6\u94a5\u5931\u8d25", ex);
            }
        } else if (keyType.equals("RSA_Private")) {
            try {
                keyAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
                RSAPrivateKeyStructure rsaPriKeyStruc = new RSAPrivateKeyStructure((ASN1Sequence)Parser.writeBytes2DERObj(hardKey));
                PrivateKeyInfo priKeyInfo = new PrivateKeyInfo(keyAlg, rsaPriKeyStruc.getDERObject());
                key = Parser.writeDERObj2Bytes(priKeyInfo);
            }
            catch (Exception ex) {
                throw new PKIException("8138", "\u52a0\u5bc6\u673a\u5bc6\u94a5\u8f6c\u6362\u8f6f\u5e93\u5bc6\u94a5\u5931\u8d25", ex);
            }
        } else {
            throw new PKIException("8138", "\u52a0\u5bc6\u673a\u5bc6\u94a5\u8f6c\u6362\u8f6f\u5e93\u5bc6\u94a5\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        return key;
    }

    public static byte[] softKey2HardKey(String keyType, byte[] softKey) throws PKIException {
        byte[] key = null;
        if (keyType.equals("RSA_Public")) {
            try {
                SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo((ASN1Sequence)Parser.writeBytes2DERObj(softKey));
                key = spki.getPublicKeyData().getBytes();
            }
            catch (Exception ex) {
                throw new PKIException("8139", "\u8f6f\u5e93\u5bc6\u94a5\u8f6c\u6362\u52a0\u5bc6\u673a\u5bc6\u94a5\u5931\u8d25", ex);
            }
        } else if (keyType.equals("RSA_Private")) {
            try {
                PrivateKeyInfo priKeyInfo = new PrivateKeyInfo((ASN1Sequence)Parser.writeBytes2DERObj(softKey));
                RSAPrivateKeyStructure rsaPriKeyStruc = new RSAPrivateKeyStructure((ASN1Sequence)priKeyInfo.getPrivateKey());
                key = Parser.writeDERObj2Bytes(rsaPriKeyStruc);
            }
            catch (Exception ex) {
                throw new PKIException("8139", "\u8f6f\u5e93\u5bc6\u94a5\u8f6c\u6362\u52a0\u5bc6\u673a\u5bc6\u94a5\u5931\u8d25", ex);
            }
        } else {
            throw new PKIException("8139", "\u8f6f\u5e93\u5bc6\u94a5\u8f6c\u6362\u52a0\u5bc6\u673a\u5bc6\u94a5\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        return key;
    }

    public static byte[] softKey2HardCustomKey(String keyType, byte[] softKey) throws PKIException {
        byte[] key = null;
        if (keyType.equals("ECDSA_Public")) {
            key = ECDSAParser.softKey2HardCustomKey(softKey);
        } else if (keyType.equals("DSA_Public")) {
            key = DSAParser.softKey2HardCustomKey(softKey);
        } else if (keyType.equals("RSA_Public")) {
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo((ASN1Sequence)Parser.writeBytes2DERObj(softKey));
            byte[] modulus = null;
            byte[] publicExponent = null;
            try {
                RSAPublicKeyStructure pubKeyStructure = RSAPublicKeyStructure.getInstance(spki.getPublicKey());
                modulus = pubKeyStructure.getModulus().toByteArray();
                publicExponent = pubKeyStructure.getPublicExponent().toByteArray();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (modulus[0] == 0) {
                byte[] modulus1 = new byte[modulus.length - 1];
                modulus1[0] = 0;
                System.arraycopy(modulus, 1, modulus1, 0, modulus.length - 1);
                modulus = Hex.encode(modulus1);
            } else {
                modulus = Hex.encode(modulus);
            }
            if (publicExponent[0] == 0) {
                byte[] publicExponent1 = new byte[publicExponent.length - 1];
                publicExponent1[0] = 0;
                System.arraycopy(publicExponent, 1, publicExponent1, 0, publicExponent.length - 1);
                publicExponent = Hex.encode(publicExponent1);
            } else {
                publicExponent = Hex.encode(publicExponent);
            }
            key = new byte[12 + modulus.length + publicExponent.length];
            System.arraycopy("2".getBytes(), 0, key, 0, "2".getBytes().length);
            byte[] modulusLen = Integer.toString(modulus.length).getBytes();
            byte[] publicExponentLen = Integer.toString(publicExponent.length).getBytes();
            System.arraycopy(modulusLen, 0, key, 2, modulusLen.length);
            System.arraycopy(modulus, 0, key, 7, modulus.length);
            System.arraycopy(publicExponentLen, 0, key, 7 + modulus.length, publicExponentLen.length);
            System.arraycopy(publicExponent, 0, key, 12 + modulus.length, publicExponent.length);
        } else if (keyType.equals("RSA_Private")) {
            PrivateKeyInfo priKeyInfo = new PrivateKeyInfo((ASN1Sequence)Parser.writeBytes2DERObj(softKey));
            RSAPrivateKeyStructure rsaPriKeyStruc = new RSAPrivateKeyStructure((ASN1Sequence)priKeyInfo.getPrivateKey());
            byte[] modulus = rsaPriKeyStruc.getModulus().toByteArray();
            byte[] privateExponent = rsaPriKeyStruc.getPrivateExponent().toByteArray();
            byte[] publicExponent = rsaPriKeyStruc.getPublicExponent().toByteArray();
            byte[] prime1 = rsaPriKeyStruc.getPrime1().toByteArray();
            byte[] prime2 = rsaPriKeyStruc.getPrime2().toByteArray();
            byte[] exponent1 = rsaPriKeyStruc.getExponent1().toByteArray();
            byte[] exponent2 = rsaPriKeyStruc.getExponent2().toByteArray();
            byte[] coefficient = rsaPriKeyStruc.getCoefficient().toByteArray();
            if (modulus[0] == 0) {
                byte[] modulus1 = new byte[modulus.length - 1];
                modulus1[0] = 0;
                System.arraycopy(modulus, 1, modulus1, 0, modulus.length - 1);
                modulus = Hex.encode(modulus1);
            } else {
                modulus = Hex.encode(modulus);
            }
            if (privateExponent[0] == 0) {
                byte[] privateExponent1 = new byte[privateExponent.length - 1];
                privateExponent1[0] = 0;
                System.arraycopy(privateExponent, 1, privateExponent1, 0, privateExponent.length - 1);
                privateExponent = Hex.encode(privateExponent1);
            } else {
                privateExponent = Hex.encode(privateExponent);
            }
            if (publicExponent[0] == 0) {
                byte[] publicExponent1 = new byte[publicExponent.length - 1];
                publicExponent1[0] = 0;
                System.arraycopy(publicExponent, 1, publicExponent1, 0, publicExponent.length - 1);
                publicExponent = Hex.encode(publicExponent1);
            } else {
                publicExponent = Hex.encode(publicExponent);
            }
            if (prime1[0] == 0) {
                byte[] prime1_1 = new byte[prime1.length - 1];
                prime1_1[0] = 0;
                System.arraycopy(prime1, 1, prime1_1, 0, prime1.length - 1);
                prime1 = Hex.encode(prime1_1);
            } else {
                prime1 = Hex.encode(prime1);
            }
            if (prime2[0] == 0) {
                byte[] prime2_1 = new byte[prime2.length - 1];
                prime2_1[0] = 0;
                System.arraycopy(prime2, 1, prime2_1, 0, prime2.length - 1);
                prime2 = Hex.encode(prime2_1);
            } else {
                prime2 = Hex.encode(prime2);
            }
            if (exponent1[0] == 0) {
                byte[] exponent1_1 = new byte[exponent1.length - 1];
                exponent1_1[0] = 0;
                System.arraycopy(exponent1, 1, exponent1_1, 0, exponent1.length - 1);
                exponent1 = Hex.encode(exponent1_1);
            } else {
                exponent1 = Hex.encode(exponent1);
            }
            if (exponent2[0] == 0) {
                byte[] exponent2_1 = new byte[exponent2.length - 1];
                exponent2_1[0] = 0;
                System.arraycopy(exponent2, 1, exponent2_1, 0, exponent2.length - 1);
                exponent2 = Hex.encode(exponent2_1);
            } else {
                exponent2 = Hex.encode(exponent2);
            }
            if (coefficient[0] == 0) {
                byte[] coefficient1 = new byte[coefficient.length - 1];
                coefficient1[0] = 0;
                System.arraycopy(coefficient, 1, coefficient1, 0, coefficient.length - 1);
                coefficient = Hex.encode(coefficient1);
            } else {
                coefficient = Hex.encode(coefficient);
            }
            key = new byte[42 + modulus.length + publicExponent.length + privateExponent.length + prime1.length + prime2.length + exponent1.length + exponent2.length + coefficient.length];
            System.arraycopy("8".getBytes(), 0, key, 0, "8".getBytes().length);
            byte[] modulusLen = Integer.toString(modulus.length).getBytes();
            byte[] privateExponentLen = Integer.toString(privateExponent.length).getBytes();
            byte[] publicExponentLen = Integer.toString(publicExponent.length).getBytes();
            byte[] prime1Len = Integer.toString(prime1.length).getBytes();
            byte[] prime2Len = Integer.toString(prime2.length).getBytes();
            byte[] exponent1Len = Integer.toString(exponent1.length).getBytes();
            byte[] exponent2Len = Integer.toString(exponent2.length).getBytes();
            byte[] coefficientLen = Integer.toString(coefficient.length).getBytes();
            System.arraycopy(modulusLen, 0, key, 2, modulusLen.length);
            System.arraycopy(modulus, 0, key, 7, modulus.length);
            System.arraycopy(privateExponentLen, 0, key, 7 + modulus.length, privateExponentLen.length);
            System.arraycopy(privateExponent, 0, key, 12 + modulus.length, privateExponent.length);
            System.arraycopy(publicExponentLen, 0, key, 12 + modulus.length + privateExponent.length, publicExponentLen.length);
            System.arraycopy(publicExponent, 0, key, 17 + modulus.length + privateExponent.length, publicExponent.length);
            System.arraycopy(prime1Len, 0, key, 17 + modulus.length + privateExponent.length + publicExponent.length, prime1Len.length);
            System.arraycopy(prime1, 0, key, 22 + modulus.length + privateExponent.length + publicExponent.length, prime1.length);
            System.arraycopy(prime2Len, 0, key, 22 + modulus.length + privateExponent.length + publicExponent.length + prime1.length, prime2Len.length);
            System.arraycopy(prime2, 0, key, 27 + modulus.length + privateExponent.length + publicExponent.length + prime1.length, prime2.length);
            System.arraycopy(exponent1Len, 0, key, 27 + modulus.length + privateExponent.length + publicExponent.length + prime1.length + prime2.length, exponent1Len.length);
            System.arraycopy(exponent1, 0, key, 32 + modulus.length + privateExponent.length + publicExponent.length + prime1.length + prime2.length, exponent1.length);
            System.arraycopy(exponent2Len, 0, key, 32 + modulus.length + privateExponent.length + publicExponent.length + prime1.length + prime2.length + exponent1.length, exponent2Len.length);
            System.arraycopy(exponent2, 0, key, 37 + modulus.length + privateExponent.length + publicExponent.length + prime1.length + prime2.length + exponent1.length, exponent2.length);
            System.arraycopy(coefficientLen, 0, key, 37 + modulus.length + privateExponent.length + publicExponent.length + prime1.length + prime2.length + exponent1.length + exponent2.length, coefficientLen.length);
            System.arraycopy(coefficient, 0, key, 42 + modulus.length + privateExponent.length + publicExponent.length + prime1.length + prime2.length + exponent1.length + exponent2.length, coefficient.length);
        } else if (keyType.equals("SM2_Private")) {
            key = ECDSAParser.sm2_softKey2HardCustomKey(softKey);
        } else if (keyType.equals("SM2_Public")) {
            key = ECDSAParser.sm2_softKey2HardCustomKey(softKey);
        } else {
            throw new PKIException("8139", "\u8f6f\u5e93\u5bc6\u94a5\u8f6c\u6362\u52a0\u5bc6\u673a\u5bc6\u94a5\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        return key;
    }

    public static byte[] customData2SoftPublicKey(String keyType, byte[] modulus, byte[] exponent) throws PKIException {
        BigInteger b_exponent;
        BigInteger b_modulus;
        AlgorithmIdentifier keyAlg = null;
        byte[] key = null;
        if (keyType.equals("RSA_Public")) {
            b_modulus = null;
            b_exponent = null;
            if (modulus[0] < 0) {
                byte[] modulus1 = new byte[modulus.length + 1];
                modulus1[0] = 0;
                System.arraycopy(modulus, 0, modulus1, 1, modulus.length);
                b_modulus = new BigInteger(modulus1);
            } else {
                b_modulus = new BigInteger(modulus);
            }
            if (exponent[0] < 0) {
                byte[] exponent1 = new byte[exponent.length + 1];
                exponent1[0] = 0;
                System.arraycopy(exponent, 0, exponent1, 1, exponent.length);
                b_exponent = new BigInteger(exponent1);
            } else {
                b_exponent = new BigInteger(exponent);
            }
        } else {
            throw new PKIException("8138", "\u52a0\u5bc6\u673a\u5bc6\u94a5\u8f6c\u6362\u8f6f\u5e93\u5bc6\u94a5\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        RSAPublicKeyStructure pubKeyStructure = new RSAPublicKeyStructure(b_modulus, b_exponent);
        byte[] pubKey = Parser.writeDERObj2Bytes(pubKeyStructure.getDERObject());
        keyAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, pubKey);
        key = Parser.writeDERObj2Bytes(spki.getDERObject());
        return key;
    }

    public static byte[] customData2SoftPublicKey(String keyType, byte[] DSA_P, byte[] DSA_Q, byte[] DSA_G, byte[] softKey) throws PKIException {
        byte[] key = null;
        if (!keyType.equals("DSA_Public")) {
            throw new PKIException("8138", "\u52a0\u5bc6\u673a\u5bc6\u94a5\u8f6c\u6362\u8f6f\u5e93\u5bc6\u94a5\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        key = DSAParser.customData2SoftPublicKey(DSA_P, DSA_Q, DSA_G, softKey);
        return key;
    }

    public static byte[] customData2SoftPrivateKey(String keyType, byte[] modulus, byte[] privateExponent, byte[] publicExponent, byte[] prime1, byte[] prime2, byte[] exponent1, byte[] exponent2, byte[] coefficient) throws PKIException {
        AlgorithmIdentifier keyAlg = null;
        byte[] key = null;
        if (keyType.equals("RSA_Private")) {
            BigInteger b_modulus = null;
            BigInteger b_privateExponent = null;
            BigInteger b_publicExponent = null;
            BigInteger b_prime1 = null;
            BigInteger b_prime2 = null;
            BigInteger b_exponent1 = null;
            BigInteger b_exponent2 = null;
            BigInteger b_coefficient = null;
            if (modulus[0] < 0) {
                byte[] modulus1 = new byte[modulus.length + 1];
                modulus1[0] = 0;
                System.arraycopy(modulus, 0, modulus1, 1, modulus.length);
                b_modulus = new BigInteger(modulus1);
            } else {
                b_modulus = new BigInteger(modulus);
            }
            if (privateExponent[0] < 0) {
                byte[] privateExponent1 = new byte[privateExponent.length + 1];
                privateExponent1[0] = 0;
                System.arraycopy(privateExponent, 0, privateExponent1, 1, privateExponent.length);
                b_privateExponent = new BigInteger(privateExponent1);
            } else {
                b_privateExponent = new BigInteger(privateExponent);
            }
            if (publicExponent[0] < 0) {
                byte[] publicExponent1 = new byte[publicExponent.length + 1];
                publicExponent1[0] = 0;
                System.arraycopy(publicExponent, 0, publicExponent1, 1, publicExponent.length);
                b_publicExponent = new BigInteger(publicExponent1);
            } else {
                b_publicExponent = new BigInteger(publicExponent);
            }
            if (prime1[0] < 0) {
                byte[] prime1_1 = new byte[prime1.length + 1];
                prime1_1[0] = 0;
                System.arraycopy(prime1, 0, prime1_1, 1, prime1.length);
                b_prime1 = new BigInteger(prime1_1);
            } else {
                b_prime1 = new BigInteger(prime1);
            }
            if (prime2[0] < 0) {
                byte[] prime2_1 = new byte[prime2.length + 1];
                prime2_1[0] = 0;
                System.arraycopy(prime2, 0, prime2_1, 1, prime2.length);
                b_prime2 = new BigInteger(prime2_1);
            } else {
                b_prime2 = new BigInteger(prime2);
            }
            if (exponent1[0] < 0) {
                byte[] exponent1_1 = new byte[exponent1.length + 1];
                exponent1_1[0] = 0;
                System.arraycopy(exponent1, 0, exponent1_1, 1, exponent1.length);
                b_exponent1 = new BigInteger(exponent1_1);
            } else {
                b_exponent1 = new BigInteger(exponent1);
            }
            if (exponent2[0] < 0) {
                byte[] exponent2_1 = new byte[exponent2.length + 1];
                exponent2_1[0] = 0;
                System.arraycopy(exponent2, 0, exponent2_1, 1, exponent2.length);
                b_exponent2 = new BigInteger(exponent2_1);
            } else {
                b_exponent2 = new BigInteger(exponent2);
            }
            if (coefficient[0] < 0) {
                byte[] coefficient1 = new byte[coefficient.length + 1];
                coefficient1[0] = 0;
                System.arraycopy(coefficient, 0, coefficient1, 1, coefficient.length);
                b_coefficient = new BigInteger(coefficient1);
            } else {
                b_coefficient = new BigInteger(coefficient);
            }
            RSAPrivateKeyStructure priKeyStructure = new RSAPrivateKeyStructure(b_modulus, b_publicExponent, b_privateExponent, b_prime1, b_prime2, b_exponent1, b_exponent2, b_coefficient);
            keyAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
            PrivateKeyInfo spki = new PrivateKeyInfo(keyAlg, priKeyStructure.getDERObject());
            key = Parser.writeDERObj2Bytes(spki.getDERObject());
        } else if (!keyType.equals("SM2_Private")) {
            throw new PKIException("8138", "\u52a0\u5bc6\u673a\u5bc6\u94a5\u8f6c\u6362\u8f6f\u5e93\u5bc6\u94a5\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        return key;
    }

    public static byte[] writeDERObj2Bytes(DEREncodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new PKIException("8136", "\u83b7\u53d6DER\u5bf9\u8c61byte\u7f16\u7801\u5931\u8d25", ex);
        }
    }

    public static DERObject writeBytes2DERObj(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream dis = new ASN1InputStream(bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
            return derObj;
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
    }

    public static byte[] convertBase64(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        return bos.toByteArray();
    }

    public static boolean isBase64Encode(byte[] data) {
        if (data.length < 4) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            boolean include = false;
            int j = 0;
            while (j < b64Code.length) {
                if (data[i] == b64Code[j]) {
                    include = true;
                    break;
                }
                ++j;
            }
            if (!include) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getRSAKeyLength(JKey jkey) throws PKIException {
        if (jkey.getKeyType().equals("RSA_Public")) {
            JCERSAPublicKey pubKey = (JCERSAPublicKey)Parser.convertPublicKey(jkey);
            return pubKey.getModulus().bitLength();
        }
        throw new PKIException("8133", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + jkey.getKeyType());
    }

    public static int getKeyLength(JKey jkey) throws PKIException {
        if (jkey.getKeyType().equals("RSA_Public")) {
            JCERSAPublicKey pubKey = (JCERSAPublicKey)Parser.convertPublicKey(jkey);
            return pubKey.getModulus().bitLength();
        }
        if (jkey.getKeyType().equals("ECDSA_Public")) {
            JCEECPublicKey pubKey = (JCEECPublicKey)Parser.convertPublicKey(jkey);
            return pubKey.getParameters().getCurve().getFieldSize();
        }
        throw new PKIException("8133", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + jkey.getKeyType());
    }

    public static boolean isEqualArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String ReverseDN(String srcDN) {
        Vector<String> dnVector = new Vector<String>();
        while (srcDN.indexOf(",") != -1) {
            dnVector.add(srcDN.substring(0, srcDN.indexOf(",")).trim());
            srcDN = srcDN.substring(srcDN.indexOf(",") + 1, srcDN.length()).trim();
        }
        dnVector.add(srcDN);
        String entryDN = "";
        int tCount = 0;
        int tSize = dnVector.size();
        int i = 0;
        while (i < tSize) {
            entryDN = tCount == 0 ? String.valueOf(dnVector.get(i).toString().trim()) + entryDN : String.valueOf(dnVector.get(i).toString().trim()) + "," + entryDN;
            ++tCount;
            ++i;
        }
        return entryDN;
    }

    public static X509CertificateStructure convertJITCertStruct2BCCertStruct(X509CertificateStructure jitCertStruct) throws PKIException {
        DERObject derObj = jitCertStruct.getDERObject();
        byte[] data = Parser.writeDERObj2Bytes(derObj);
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream bcDerIns = new ASN1InputStream(bis);
        try {
            ASN1Sequence bcSeq = (ASN1Sequence)bcDerIns.readObject();
            return new X509CertificateStructure(bcSeq);
        }
        catch (IOException ex) {
            throw new PKIException("", "convert JITX509CertStructure to BCX509CertStructure failture.", ex);
        }
    }

    public static CertificateList convertJITCertList2BCCertList(CertificateList jitCertList) throws PKIException {
        DERObject derObj = jitCertList.getDERObject();
        byte[] data = Parser.writeDERObj2Bytes(derObj);
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream bcDerIns = new ASN1InputStream(bis);
        try {
            ASN1Sequence bcSeq = (ASN1Sequence)bcDerIns.readObject();
            return new CertificateList(bcSeq);
        }
        catch (IOException ex) {
            throw new PKIException("", "convert JITX509CertStructure to BCX509CertStructure failture.", ex);
        }
    }

    public static JKey convertJITPublicKey(PublicKey key) throws PKIException {
        if (key.getAlgorithm().indexOf("RSA") >= 0) {
            return new JKey("RSA_Public", key.getEncoded());
        }
        if (key.getAlgorithm().indexOf("1.2.840.10045.2.1") >= 0) {
            return new JKey("ECDSA_Public", key.getEncoded());
        }
        if (key.getAlgorithm().indexOf("ECDSA") >= 0) {
            return new JKey("ECDSA_Public", key.getEncoded());
        }
        if (key.getAlgorithm().indexOf("EC") >= 0) {
            return new JKey("ECDSA_Public", key.getEncoded());
        }
        throw new PKIException("8133", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + key.getAlgorithm());
    }

    public static byte[] cvtPKCS8PrvKeyToCryptoAPIKey(byte[] prikey, int keysize) throws PKIException {
        byte[] privateKey = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(prikey);
            ASN1InputStream dis = new ASN1InputStream(bis);
            DERObject derObj = null;
            derObj = dis.readObject();
            PrivateKeyInfo priKeyInfo = new PrivateKeyInfo((ASN1Sequence)derObj);
            ASN1Sequence secq = (ASN1Sequence)priKeyInfo.getPrivateKey();
            int len = 0;
            int totleSize = keysize / 16 * 9;
            int bigLen = keysize / 8;
            int smallLen = keysize / 16;
            byte[] totlePrivate = new byte[totleSize];
            DERInteger derInt7 = (DERInteger)secq.getObjectAt(3);
            byte[] derInt7Data = Parser.writeDERObj2Bytes(derInt7);
            System.arraycopy(derInt7Data, derInt7Data.length - bigLen, totlePrivate, 0, bigLen);
            DERInteger derInt6 = (DERInteger)secq.getObjectAt(8);
            byte[] derInt6Data = Parser.writeDERObj2Bytes(derInt6);
            System.arraycopy(derInt6Data, derInt6Data.length - smallLen, totlePrivate, len += bigLen, smallLen);
            DERInteger derInt5 = (DERInteger)secq.getObjectAt(7);
            byte[] derInt5Data = Parser.writeDERObj2Bytes(derInt5);
            System.arraycopy(derInt5Data, derInt5Data.length - smallLen, totlePrivate, len += smallLen, smallLen);
            DERInteger derInt4 = (DERInteger)secq.getObjectAt(6);
            byte[] derInt4Data = Parser.writeDERObj2Bytes(derInt4);
            System.arraycopy(derInt4Data, derInt4Data.length - smallLen, totlePrivate, len += smallLen, smallLen);
            DERInteger derInt3 = (DERInteger)secq.getObjectAt(5);
            byte[] derInt3Data = Parser.writeDERObj2Bytes(derInt3);
            System.arraycopy(derInt3Data, derInt3Data.length - smallLen, totlePrivate, len += smallLen, smallLen);
            DERInteger derInt2 = (DERInteger)secq.getObjectAt(4);
            byte[] derInt2Data = Parser.writeDERObj2Bytes(derInt2);
            System.arraycopy(derInt2Data, derInt2Data.length - smallLen, totlePrivate, len += smallLen, smallLen);
            DERInteger derInt1 = (DERInteger)secq.getObjectAt(1);
            byte[] derInt1Data = Parser.writeDERObj2Bytes(derInt1);
            System.arraycopy(derInt1Data, derInt1Data.length - bigLen, totlePrivate, len += smallLen, bigLen);
            privateKey = new byte[totlePrivate.length];
            int i = 0;
            while (i < totlePrivate.length) {
                privateKey[i] = totlePrivate[totlePrivate.length - i - 1];
                ++i;
            }
        }
        catch (Exception ex) {
            throw new PKIException("0", "\u5bc6\u94a5\u8f6c\u6362\u64cd\u4f5c\u5931\u8d25 " + ex.toString());
        }
        return privateKey;
    }

    public static byte[] cvtCryptoAPIKeyToPKCS8PrvKey(byte[] cryptoKey, int keySize) throws PKIException {
        byte[] key = null;
        byte[] privateKey = new byte[cryptoKey.length];
        int i = 0;
        while (i < cryptoKey.length) {
            privateKey[i] = cryptoKey[cryptoKey.length - i - 1];
            ++i;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(privateKey);
            int bigLen = keySize / 8;
            int smallLen = keySize / 16;
            byte[] der3Data = new byte[bigLen];
            bis.read(der3Data);
            DERInteger der3Int = Parser.cvtDERInt(der3Data);
            byte[] der8Data = new byte[smallLen];
            bis.read(der8Data);
            DERInteger der8Int = Parser.cvtDERInt(der8Data);
            byte[] der7Data = new byte[smallLen];
            bis.read(der7Data);
            DERInteger der7Int = Parser.cvtDERInt(der7Data);
            byte[] der6Data = new byte[smallLen];
            bis.read(der6Data);
            DERInteger der6Int = Parser.cvtDERInt(der6Data);
            byte[] der5Data = new byte[smallLen];
            bis.read(der5Data);
            DERInteger der5Int = Parser.cvtDERInt(der5Data);
            byte[] der4Data = new byte[smallLen];
            bis.read(der4Data);
            DERInteger der4Int = Parser.cvtDERInt(der4Data);
            byte[] der1Data = new byte[bigLen];
            bis.read(der1Data);
            DERInteger der1Int = Parser.cvtDERInt(der1Data);
            byte[] byArray = new byte[3];
            byArray[0] = 1;
            byArray[2] = 1;
            byte[] der2Data = byArray;
            DERInteger der2Int = new DERInteger(der2Data);
            byte[] der0Data = new byte[1];
            DERInteger der0Int = new DERInteger(der0Data);
            DEREncodableVector derV = new DEREncodableVector();
            derV.add(der0Int);
            derV.add(der1Int);
            derV.add(der2Int);
            derV.add(der3Int);
            derV.add(der4Int);
            derV.add(der5Int);
            derV.add(der6Int);
            derV.add(der7Int);
            derV.add(der8Int);
            DERSequence derSeq = new DERSequence(derV);
            AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
            RSAPrivateKeyStructure rsaPriKeyStruc = new RSAPrivateKeyStructure(derSeq);
            PrivateKeyInfo priKeyInfo = new PrivateKeyInfo(keyAlg, rsaPriKeyStruc.getDERObject());
            key = Parser.writeDERObj2Bytes(priKeyInfo);
            return key;
        }
        catch (Exception ex) {
            throw new PKIException("0", "\u5bc6\u94a5\u8f6c\u6362\u64cd\u4f5c\u5931\u8d25 " + ex.toString());
        }
    }

    private static DERInteger cvtDERInt(byte[] src) {
        if (src[0] < 0) {
            byte[] tmp = new byte[src.length + 1];
            tmp[0] = 0;
            System.arraycopy(src, 0, tmp, 1, src.length);
            return new DERInteger(tmp);
        }
        return new DERInteger(src);
    }

    public static byte[] SM2PrvKeyEnc(byte[] prvData, byte[] pubData) throws PKIException {
        if (prvData == null || pubData == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(pubData);
        ASN1InputStream dis = new ASN1InputStream(bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        DERSequence seq = new DERSequence(derObj);
        ASN1Sequence asn1 = DERSequence.getInstance(derObj);
        int size = asn1.size();
        byte[] derecpoint = null;
        derecpoint = ((DERBitString)asn1.getObjectAt(1)).getBytes();
        byte[] ecPoint = new byte[derecpoint.length - 1];
        System.arraycopy(derecpoint, 1, ecPoint, 0, derecpoint.length - 1);
        byte[] ecValue = new byte[32];
        System.arraycopy(prvData, 8, ecValue, 0, 32);
        byte[] ret = ECDSAParser.customData2SoftECPrivKey(ecPoint, ecValue);
        return ret;
    }

    public static void main(String[] args) {
        try {
            FileInputStream fin = new FileInputStream("D:/pubkey");
            byte[] pubdata = null;
            pubdata = new byte[fin.available()];
            fin.read(pubdata);
            fin.close();
            fin = new FileInputStream("D:/prvkey");
            byte[] prvdata = null;
            prvdata = new byte[fin.available()];
            fin.read(prvdata);
            fin.close();
            byte[] data = Parser.SM2PrvKeyEnc(Base64.decode((byte[])prvdata), Base64.decode((byte[])pubdata));
            System.out.println(new String(Base64.encode((byte[])data)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

