/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki;

import cn.com.jit.ida.util.ini.ProFile;
import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.asn1.DERObjectIdentifier;
import cn.com.jit.ida.util.pki.asn1.x509.X509Name;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PKIToolConfig {
    private String PKITOOL = "PKITOOL";
    private final String VERIFY_P10 = "VerifyP10Signature";
    private final String REVERSE_DN = "ReverseDN";
    private final String CERT_ZH_ENCODE = "X509CertZHEncode";
    private final String JNIUSE = "JNIUse";
    private final String P11_FILE = "P11File";
    private final String P11_CONFIG = "P11Config";
    private final String P11_PASSWORD = "P11Password";
    private final String SUPPORT_KEY_SIZE = "SupportKeySize";
    private final String MASTERKEY_ENC = "MasterKeyEnc";
    private final String MASTERKEY_TYPE = "MasterKeyType";
    private final String MASTERKEY_VALUE = "MasterKeyValue";
    private final String SSF33_KEY = "SSF33Key";
    private final String SSF33_KEYGEN = "SSF33KeyGenerate";
    private final String SSF33_ECB = "SSF33ECB";
    private final String NOEXPORT_RSA_KEYCOUNT = "NoExportRSAKeyCount";
    private final String NOEXPORT_RSA_KEYTYPE = "NoExportRSAKeyType";
    private final String NOEXPORT_RSA_KEYVALUE = "NoExportRSAKeyValue";
    private final String NOEXPORT_RSA_PUBKEYVALUE = "NoExportRSAPubKeyValue";
    private final String NOEXPORT_RSA_PRVKEYVALUE = "NoExportRSAPriKeyValue";
    private final String NOEXPORT_ECDSA_KEYTYPE = "NoExportECDSAKeyType";
    private final String NOEXPORT_ECDSA_PUBKEYVALUE = "NoExportECDSAPubKeyValue";
    private final String NOEXPORT_ECDSA_PRVKEYVALUE = "NoExportECDSAPriKeyValue";
    private final String NOEXPORT_ECDSA_ENCKEYTYPE = "NoExportECDSAEncKeyType";
    private final String NOEXPORT_ECDSA_ENCPUBKEYVALUE = "NoExportECDSAEncPubKeyValue";
    private final String NOEXPORT_ECDSA_ENCPRVKEYVALUE = "NoExportECDSAEncPriKeyValue";
    private final String NOEXPORT_DSA_KEYTYPE = "NoExportDSAKeyType";
    private final String NOEXPORT_DSA_PUBKEYVALUE = "NoExportDSAPubKeyValue";
    private final String NOEXPORT_DSA_PRVKEYVALUE = "NoExportDSAPriKeyValue";
    private final String P11_CFG_LIBRARY = "library";
    private final String P11_CFG_NAME = "name";
    private final String P11_CFG_DESCRIPTION = "description";
    private final String P11_CFG_SLOTLISTINDEX = "slotListIndex";
    private final String TELETEX_STRING = "TeletexString";
    private static String teletexstr = "default";
    private boolean verifyP10Signature = false;
    private static boolean reverseDN = true;
    private static boolean useUTF8String = true;
    private String jniUse = "JNI1";
    private String p11File = null;
    private String p11Config = null;
    private String p11Password = null;
    private String supportKeySize = null;
    private String masterKeyEnc = null;
    private String masterKeyType = null;
    private String masterKeyValue = null;
    private String SSF33Key = null;
    private String SSF33KeyGenerate = null;
    private String SSF33ECB = null;
    private String noExportRSAKeyCount = null;
    private String noExportRSAKeyType = null;
    private String noExportRSAKeyValue = null;
    private String noExportRSAPubKeyValue = null;
    private String noExportRSAPriKeyValue = null;
    private String noExportECDSAKeyType = null;
    private String noExportECDSAPubKeyValue = null;
    private String noExportECDSAPriKeyValue = null;
    private String noExportECDSAEncKeyType = null;
    private String noExportECDSAEncPubKeyValue = null;
    private String noExportECDSAEncPriKeyValue = null;
    private String NoExportDSAKeyType = null;
    private String noExportDSAPubKeyValue = null;
    private String noExportDSAPriKeyValue = null;
    private String p11ProviderName = null;
    private String p11Description = null;
    private String p11SlotListIndex = null;
    private String p11Library = "";
    private boolean exists1 = true;
    private boolean exists2 = true;
    private String SEC_PUBLIC = "PUBLIC";
    private String P11_SLOT = "P11Slot";
    private String p11_slot = null;
    private String DN_RULES = "DNRULES";
    private static HashMap dnrules = null;

    public void LoadOpt(String tag) throws PKIException {
        File file;
        if (tag != null) {
            this.PKITOOL = tag;
        }
        String path1 = null;
        String path2 = "./pkitool.ini";
        path1 = System.getProperty("PKIToolConfig");
        boolean usePath1 = true;
        if (path1 == null) {
            usePath1 = false;
            file = new File(path2);
            if (!file.exists()) {
                this.exists1 = false;
                System.out.println(System.getProperty("user.dir"));
                System.out.println("Couldn't find config file named 'pkitool.ini'. All the pkitool parameters will be set to default value.");
            }
        } else {
            file = new File(path1);
            if (!file.exists()) {
                this.exists1 = false;
                System.out.println("Couldn't find config file named 'pkitool.ini'. All the pkitool parameters will be set to default value.");
            }
        }
        if (this.exists1) {
            String strTeletex;
            String strUseUTF8;
            String strReverseDN;
            ProFile proFile = new ProFile();
            if (usePath1) {
                proFile.load(path1);
            } else {
                proFile.load(path2);
            }
            String strVerifyP10Sig = proFile.getValue(this.PKITOOL, "VerifyP10Signature");
            if ("true".equalsIgnoreCase(strVerifyP10Sig)) {
                this.verifyP10Signature = true;
            }
            if ((strReverseDN = proFile.getValue(this.PKITOOL, "ReverseDN")) != null && "false".equalsIgnoreCase(strReverseDN)) {
                reverseDN = false;
            }
            if ((strUseUTF8 = proFile.getValue(this.PKITOOL, "X509CertZHEncode")) != null && !"UTF8String".equalsIgnoreCase(strUseUTF8)) {
                useUTF8String = false;
            }
            this.jniUse = proFile.getValue(this.PKITOOL, "JNIUse");
            if (this.jniUse == null) {
                System.out.println("get JNIUSE from pkitool.ini error, now set jniUse JNI2...");
                this.jniUse = "JNI2";
            }
            if ((strTeletex = proFile.getValue(this.PKITOOL, "TeletexString")) != null && !"".equalsIgnoreCase(strTeletex)) {
                teletexstr = strTeletex;
            }
            if (tag.equals(this.PKITOOL)) {
                strReverseDN = proFile.getValue(this.SEC_PUBLIC, "ReverseDN");
                if (strReverseDN != null && "false".equalsIgnoreCase(strReverseDN)) {
                    reverseDN = false;
                }
                if ((strUseUTF8 = proFile.getValue(this.SEC_PUBLIC, "X509CertZHEncode")) != null && !"UTF8String".equalsIgnoreCase(strUseUTF8)) {
                    useUTF8String = false;
                }
                if ((strTeletex = proFile.getValue(this.SEC_PUBLIC, "TeletexString")) != null && !"".equalsIgnoreCase(strTeletex)) {
                    teletexstr = strTeletex;
                }
            }
            this.p11_slot = proFile.getValue(this.jniUse, this.P11_SLOT);
            String[] strRules = proFile.getKeys(this.DN_RULES);
            if (strRules == null) {
                dnrules = null;
            } else {
                dnrules = new HashMap();
                int i = 0;
                while (i < strRules.length) {
                    String value = proFile.getValue(this.DN_RULES, strRules[i]);
                    DERObjectIdentifier oid = (DERObjectIdentifier)X509Name.DefaultLookUp.get(strRules[i].toLowerCase());
                    dnrules.put(oid, value);
                    ++i;
                }
            }
            this.p11File = proFile.getValue(this.jniUse, "P11File");
            if (this.p11File != null) {
                this.p11File.replaceAll("\\\\\\\\", "/");
            }
            this.p11Config = proFile.getValue(this.jniUse, "P11Config");
            this.p11Password = proFile.getValue(this.jniUse, "P11Password");
            this.supportKeySize = proFile.getValue(this.jniUse, "SupportKeySize");
            this.masterKeyEnc = proFile.getValue(this.jniUse, "MasterKeyEnc");
            this.masterKeyType = proFile.getValue(this.jniUse, "MasterKeyType");
            this.masterKeyValue = proFile.getValue(this.jniUse, "MasterKeyValue");
            this.SSF33Key = proFile.getValue(this.jniUse, "SSF33Key");
            this.SSF33KeyGenerate = proFile.getValue(this.jniUse, "SSF33KeyGenerate");
            this.SSF33ECB = proFile.getValue(this.jniUse, "SSF33ECB");
            this.noExportRSAKeyCount = proFile.getValue(this.jniUse, "NoExportRSAKeyCount");
            this.noExportRSAKeyType = proFile.getValue(this.jniUse, "NoExportRSAKeyType");
            this.noExportRSAKeyValue = proFile.getValue(this.jniUse, "NoExportRSAKeyValue");
            this.noExportRSAPubKeyValue = proFile.getValue(this.jniUse, "NoExportRSAPubKeyValue");
            this.noExportRSAPriKeyValue = proFile.getValue(this.jniUse, "NoExportRSAPriKeyValue");
            this.noExportECDSAKeyType = proFile.getValue(this.jniUse, "NoExportECDSAKeyType");
            this.noExportECDSAPubKeyValue = proFile.getValue(this.jniUse, "NoExportECDSAPubKeyValue");
            this.noExportECDSAPriKeyValue = proFile.getValue(this.jniUse, "NoExportECDSAPriKeyValue");
            this.NoExportDSAKeyType = proFile.getValue(this.jniUse, "NoExportDSAKeyType");
            this.noExportDSAPubKeyValue = proFile.getValue(this.jniUse, "NoExportDSAPubKeyValue");
            this.noExportDSAPriKeyValue = proFile.getValue(this.jniUse, "NoExportDSAPriKeyValue");
            this.noExportECDSAEncKeyType = proFile.getValue(this.jniUse, "NoExportECDSAEncKeyType");
            this.noExportECDSAEncPubKeyValue = proFile.getValue(this.jniUse, "NoExportECDSAEncPubKeyValue");
            this.noExportECDSAEncPriKeyValue = proFile.getValue(this.jniUse, "NoExportECDSAEncPriKeyValue");
            if (this.p11Config == null) {
                this.exists2 = false;
            } else {
                file = new File(this.p11Config);
                if (!file.exists()) {
                    this.exists2 = false;
                }
            }
            if (this.exists2) {
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(this.p11Config));
                    this.p11ProviderName = props.getProperty("name");
                    this.p11Library = props.getProperty("library");
                    this.p11Description = props.getProperty("description");
                    this.p11SlotListIndex = props.getProperty("slotListIndex");
                    if (this.p11Library != null) {
                        this.p11Library.replaceAll("\\\\\\\\\\\\", "/");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isReLoaded() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        if (!this.exists2) {
            throw new PKIException("8599", "couldn't find '" + this.p11Config + "' file");
        }
        return this.p11Library.equals(this.p11File);
    }

    public static boolean isReverseDN() {
        return reverseDN;
    }

    public static boolean isUseUTF8String() {
        return useUTF8String;
    }

    public boolean isVerifyP10Signature() {
        return this.verifyP10Signature;
    }

    public String getJniUse() {
        return this.jniUse;
    }

    public String getMasterKeyEnc() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.masterKeyEnc;
    }

    public int getNoExportRSAKeyCount() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        int keyCount = -1;
        try {
            keyCount = Integer.parseInt(this.noExportRSAKeyCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyCount;
    }

    public String getNoExportRSAKeyType() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportRSAKeyType;
    }

    public String getNoExportECCKeyType() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportECDSAKeyType;
    }

    public String getNoExportECDSAPubKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportECDSAPubKeyValue;
    }

    public String getNoExportECDSAPriKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportECDSAPriKeyValue;
    }

    public String getNoExportDSAKeyType() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.NoExportDSAKeyType;
    }

    public String getNoExportDSAPubKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportDSAPubKeyValue;
    }

    public String getNoExportDSAPriKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportDSAPriKeyValue;
    }

    public String getNoExportRSAKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportRSAKeyValue;
    }

    public String getNoExportRSAPriKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportRSAPriKeyValue;
    }

    public String getNoExportRSAPubKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportRSAPubKeyValue;
    }

    public String getP11Config() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.p11Config;
    }

    public String getP11File() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.p11File;
    }

    public String getP11Password() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.p11Password;
    }

    public String getSupportKeySize() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.supportKeySize;
    }

    public String getSSF33ECB() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.SSF33ECB;
    }

    public String getSSF33Key() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.SSF33Key;
    }

    public String getSSF33KeyGenerate() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.SSF33KeyGenerate;
    }

    public String getP11ProviderName() throws PKIException {
        if (!this.exists2) {
            throw new PKIException("8599", "couldn't find '" + this.p11Config + "' file");
        }
        return "SunPKCS11-" + this.p11ProviderName;
    }

    public String getNoExportRSAKey(int keyID) throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return String.valueOf(this.noExportRSAKeyValue) + keyID;
    }

    public String getMasterKeyType() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.masterKeyType;
    }

    public String getMasterKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.masterKeyValue;
    }

    public String getP11Description() throws PKIException {
        if (!this.exists2) {
            throw new PKIException("8599", "couldn't find '" + this.p11Config + "' file");
        }
        return this.p11Description;
    }

    public String getP11Library() throws PKIException {
        if (!this.exists2) {
            throw new PKIException("8599", "couldn't find '" + this.p11Config + "' file");
        }
        return this.p11Library;
    }

    public String getP11SlotListIndex() throws PKIException {
        if (!this.exists2) {
            throw new PKIException("8599", "couldn't find '" + this.p11Config + "' file");
        }
        return this.p11SlotListIndex;
    }

    public static String getTeletexstr() {
        return teletexstr;
    }

    public String getNoExportECCEncKeyType() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportECDSAEncKeyType;
    }

    public String getNoExportECDSAEncPubKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportECDSAEncPubKeyValue;
    }

    public String getNoExportECDSAEncPriKeyValue() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.noExportECDSAEncPriKeyValue;
    }

    public String getSlot() throws PKIException {
        if (!this.exists1) {
            throw new PKIException("8599", "couldn't find 'pkitool.ini' file");
        }
        return this.p11_slot;
    }

    public static Map getDnRules() {
        return dnrules;
    }

    public String getTagName() {
        return this.PKITOOL;
    }
}

