/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki;

import cn.com.jit.ida.util.pki.PKIException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;

public class ECDSAParser {
    public static byte[] customData2SoftPublicKey(byte[] eccPublicKey, byte[] ecParams) throws PKIException {
        byte[] pubKey = new byte[eccPublicKey.length + 1];
        pubKey[0] = 4;
        System.arraycopy(eccPublicKey, 0, pubKey, 1, eccPublicKey.length);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (DEREncodable)new DERObjectIdentifier("1.2.156.10197.1.301"));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(algorithmIdentifier, pubKey);
        byte[] publicKey = info.getDEREncoded();
        return publicKey;
    }

    public static byte[] softKey2HardCustomKey(byte[] softKey) throws PKIException {
        byte[] key = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(softKey);
        ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo((ASN1Sequence)derObj);
        byte[] pubKeyData = spki.getPublicKeyData().getBytes();
        byte[] pubKeyDataResult = new byte[pubKeyData.length - 1];
        System.arraycopy(pubKeyData, 1, pubKeyDataResult, 0, pubKeyDataResult.length);
        pubKeyData = Hex.encode((byte[])pubKeyDataResult);
        return key;
    }

    public static byte[] customData2SoftSignData(byte[] hardSignData) throws PKIException {
        byte[] signData = null;
        byte[] b_r = null;
        byte[] b_s = null;
        int signDataLen = hardSignData.length / 2;
        b_r = new byte[signDataLen];
        b_s = new byte[signDataLen];
        System.arraycopy(hardSignData, 0, b_r, 0, signDataLen);
        System.arraycopy(hardSignData, signDataLen, b_s, 0, signDataLen);
        BigInteger r = new BigInteger(b_r);
        BigInteger s = new BigInteger(b_s);
        DERInteger d_r = new DERInteger(r);
        DERInteger d_s = new DERInteger(s);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)d_r);
        v.add((DEREncodable)d_s);
        DERSequence sign = new DERSequence((DEREncodableVector)v);
        signData = sign.getDEREncoded();
        return signData;
    }

    public static byte[] customData2SoftECPrivKey(byte[] EcPoint, byte[] ecValue) throws PKIException {
        DERBitString pubkey = new DERBitString(EcPoint);
        DERInteger version = new DERInteger(1);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)version);
        if (ecValue != null) {
            v.add((DEREncodable)new DEROctetString(ecValue));
        }
        v.add((DEREncodable)pubkey);
        DERSequence derseq = new DERSequence((DEREncodableVector)v);
        byte[] key = derseq.getDEREncoded();
        return key;
    }

    public static byte[] sm2_softKey2HardCustomKey(byte[] softKey) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(softKey);
        ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        DERSequence seq = new DERSequence((DEREncodable)derObj);
        ASN1Sequence asn1 = DERSequence.getInstance((Object)derObj);
        int size = asn1.size();
        byte[] derecpoint = null;
        byte[] derprvkey = null;
        byte[] key = null;
        if (2 == size) {
            derecpoint = ((DERBitString)asn1.getObjectAt(1)).getBytes();
        } else {
            derprvkey = ((DEROctetString)asn1.getObjectAt(1)).getOctets();
            derecpoint = ((DERBitString)asn1.getObjectAt(2)).getBytes();
        }
        derecpoint = Hex.encode((byte[])derecpoint);
        if (derprvkey != null) {
            derprvkey = Hex.encode((byte[])derprvkey);
        }
        if (derprvkey != null) {
            key = new byte[12 + derprvkey.length + derecpoint.length];
            System.arraycopy("2".getBytes(), 0, key, 0, "2".getBytes().length);
            byte[] derprvkeyLen = Integer.toString(derprvkey.length).getBytes();
            byte[] derecpointLen = Integer.toString(derecpoint.length).getBytes();
            System.arraycopy(derprvkeyLen, 0, key, 2, derprvkeyLen.length);
            System.arraycopy(derprvkey, 0, key, 7, derprvkey.length);
            System.arraycopy(derecpointLen, 0, key, 7 + derprvkey.length, derecpointLen.length);
            System.arraycopy(derecpoint, 0, key, 12 + derprvkey.length, derecpoint.length);
        } else {
            key = new byte[12 + derecpoint.length];
            System.arraycopy("1".getBytes(), 0, key, 0, "1".getBytes().length);
            byte[] derecpointLen = Integer.toString(derecpoint.length).getBytes();
            System.arraycopy(derecpointLen, 0, key, 2, derecpointLen.length);
            System.arraycopy(derecpoint, 0, key, 7, derecpoint.length);
        }
        return key;
    }

    public static void main(String[] args) {
    }
}

