/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.ida.util.pki;

import cn.com.jit.ida.util.pki.PKIException;
import cn.com.jit.ida.util.pki.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.spec.DSAParameterSpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public class DSAParser {
    public static byte[] softKey2HardCustomKey(byte[] softKey) throws PKIException {
        byte[] key = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(softKey);
        ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
        DERObject derObj = null;
        try {
            derObj = dis.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo((ASN1Sequence)derObj);
        byte[] pubParams = spki.getAlgorithmId().getParameters().getDERObject().getDEREncoded();
        byte[] pubKeyData = spki.getPublicKeyData().getBytes();
        ByteArrayInputStream bis1 = new ByteArrayInputStream(pubParams);
        ASN1InputStream dis1 = new ASN1InputStream((InputStream)bis1);
        DERObject derObj1 = null;
        try {
            derObj1 = dis1.readObject();
        }
        catch (Exception ex) {
            throw new PKIException("8137", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        DSAParameter dsaParams = new DSAParameter((ASN1Sequence)derObj1);
        byte[] P = dsaParams.getP().toByteArray();
        byte[] Q = dsaParams.getQ().toByteArray();
        byte[] G = dsaParams.getG().toByteArray();
        if (P[0] == 0) {
            byte[] P1 = new byte[P.length - 1];
            P1[0] = 0;
            System.arraycopy(P, 1, P1, 0, P.length - 1);
            P = Hex.encode(P1);
        } else {
            P = Hex.encode(P);
        }
        if (Q[0] == 0) {
            byte[] Q1 = new byte[Q.length - 1];
            Q1[0] = 0;
            System.arraycopy(Q, 1, Q1, 0, Q.length - 1);
            Q = Hex.encode(Q1);
        } else {
            Q = Hex.encode(Q);
        }
        if (G[0] == 0) {
            byte[] G1 = new byte[G.length - 1];
            G1[0] = 0;
            System.arraycopy(G, 1, G1, 0, G.length - 1);
            G = Hex.encode(G1);
        } else {
            G = Hex.encode(G);
        }
        pubKeyData = Hex.encode(pubKeyData);
        key = new byte[22 + P.length + Q.length + G.length + pubKeyData.length];
        System.arraycopy("4".getBytes(), 0, key, 0, "4".getBytes().length);
        byte[] PLen = Integer.toString(P.length).getBytes();
        byte[] QLen = Integer.toString(Q.length).getBytes();
        byte[] GLen = Integer.toString(G.length).getBytes();
        byte[] pubKeyDataLen = Integer.toString(pubKeyData.length).getBytes();
        System.arraycopy(PLen, 0, key, 2, PLen.length);
        System.arraycopy(P, 0, key, 7, P.length);
        System.arraycopy(QLen, 0, key, 7 + P.length, QLen.length);
        System.arraycopy(Q, 0, key, 12 + P.length, Q.length);
        System.arraycopy(GLen, 0, key, 12 + P.length + Q.length, GLen.length);
        System.arraycopy(G, 0, key, 17 + P.length + Q.length, G.length);
        System.arraycopy(pubKeyDataLen, 0, key, 17 + P.length + Q.length + G.length, pubKeyDataLen.length);
        System.arraycopy(pubKeyData, 0, key, 22 + P.length + Q.length + G.length, pubKeyData.length);
        return key;
    }

    public static byte[] customData2SoftPublicKey(byte[] DSA_P, byte[] DSA_Q, byte[] DSA_G, byte[] softKey) throws PKIException {
        byte[] key = null;
        BigInteger b_DSA_P = null;
        BigInteger b_DSA_Q = null;
        BigInteger b_DSA_G = null;
        if (DSA_P[0] < 0) {
            byte[] DSA_P1 = new byte[DSA_P.length + 1];
            DSA_P1[0] = 0;
            System.arraycopy(DSA_P, 0, DSA_P1, 1, DSA_P.length);
            b_DSA_P = new BigInteger(DSA_P1);
        } else {
            b_DSA_P = new BigInteger(DSA_P);
        }
        if (DSA_Q[0] < 0) {
            byte[] DSA_Q1 = new byte[DSA_Q.length + 1];
            DSA_Q1[0] = 0;
            System.arraycopy(DSA_Q, 0, DSA_Q1, 1, DSA_Q.length);
            b_DSA_Q = new BigInteger(DSA_Q1);
        } else {
            b_DSA_Q = new BigInteger(DSA_Q);
        }
        if (DSA_G[0] < 0) {
            byte[] DSA_G1 = new byte[DSA_G.length + 1];
            DSA_G1[0] = 0;
            System.arraycopy(DSA_G, 0, DSA_G1, 1, DSA_G.length);
            b_DSA_G = new BigInteger(DSA_G1);
        } else {
            b_DSA_G = new BigInteger(DSA_G);
        }
        DSAParameterSpec dsaSpec = new DSAParameterSpec(b_DSA_P, b_DSA_Q, b_DSA_G);
        SubjectPublicKeyInfo DSAPubkey = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (DEREncodable)new DSAParameter(dsaSpec.getP(), dsaSpec.getQ(), dsaSpec.getG()).getDERObject()), softKey);
        return DSAPubkey.getDEREncoded();
    }

    public static void main(String[] args) {
    }
}

