import Vue from 'vue'
import Router from 'vue-router'
import logQuery from '@/views/logQuery/logQuery'
import logFiltering from '@/views/logFiltering/logFiltering'
import home from '@/views/home/home'

Vue.use(Router)

const router = new Router({
  routes: [
    {
      path: '/',
      redirect: '/logQuery'
    },
    {
      path: '/home',
      name: 'home',
      component: home,
      redirect: '/logQuery',
      children: [
        {
          path: '/logQuery',
          name: 'logQuery',
          component: logQuery
        },
        {
          path: '/logFiltering',
          name: 'logFiltering',
          component: logFiltering
        }
      ]
    }

  ]
})

// 导航守卫
// 使用 router.beforeEach 注册一个全局前置守卫，判断用户是否登陆
// router.beforeEach((to, from, next) => {
//   // debugger
//   if (to.path === '/login') {
//     next();
//     window.scrollTo(0,0)

//   }
//    else {
//     let token = store.state.user.token;
//     if (token === undefined) {
//       next('/login');
//       window.scrollTo(0,0)

//     }
//     else {

//           next();
//           window.scrollTo(0,0)

//     }
//   }
// });
export default router
